package ru.yandex.partner.core.operation;

import java.util.List;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.entity.block.container.IncomingFieldsContainer;
import ru.yandex.partner.core.multitype.add.AbstractPartnerAddOperationTypeSupport;
import ru.yandex.partner.core.props.CoreModel;

/**
 * Тайп-саппорт для операций добавления, выставляющий дефолтные значения
 * в соответствии с описанием в CoreModel
 */
public class DefaultsInitializingAddSupport<M extends ModelWithId, A extends IncomingFieldsContainer, B>
        extends AbstractPartnerAddOperationTypeSupport<M, A, B> {
    private final CoreModel<M> coreModel;

    public DefaultsInitializingAddSupport(CoreModel<M> coreModel) {
        this.coreModel = coreModel;
    }

    @Override
    public void onPreValidated(A addContainer, List<M> models) {
        var incomingFields = addContainer.getIncomingFields();
        if (incomingFields != null) {
            for (M model : models) {
                coreModel.processAddDefaults(model, incomingFields.getUpdatedPropertiesPerModel());
            }
        }
    }

    @Override
    public Class<M> getTypeClass() {
        return coreModel.getModelClass();
    }
}
