package ru.yandex.partner.core.operation;

import java.util.List;

import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;
import ru.yandex.partner.core.props.CoreModel;
import ru.yandex.partner.core.typesupport.update.PartnerBaseUpdateOperationTypeSupport;

/**
 * Тайп-саппорт для операций редактирования, выставляющий дефолтные значения
 * в соответствии с описанием в CoreModel
 */
public class DefaultsInitializingUpdateSupport<M extends ModelWithId, A extends UpdateOperationContainer<M>, B, C>
        extends PartnerBaseUpdateOperationTypeSupport<M, A, B, C> {
    private final CoreModel<M> coreModel;

    public DefaultsInitializingUpdateSupport(CoreModel<M> coreModel,
                                             PartnerRepositoryTypeSupportFacade<? super M, A, B, C> repositoryFacade) {
        super(repositoryFacade);
        this.coreModel = coreModel;
    }

    @Override
    public void onChangesApplied(A updateContainer,
                                 List<AppliedChanges<M>> appliedChanges) {
        for (AppliedChanges<M> changes : appliedChanges) {
            coreModel.processEditDefaults(changes);
        }
    }

    @Override
    public Class<M> getTypeClass() {
        return coreModel.getModelClass();
    }
}
