package ru.yandex.partner.core.operation;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.service.type.add.AddOperationTypeSupportFacade;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.partner.core.multitype.add.PartnerAddOperationTypeSupport;

import static ru.yandex.direct.multitype.typesupport.TypeSupportUtils.getObjectsByTypeSupports;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class PartnerAddOperationTypeSupportFacade<T extends ModelWithId, A extends UpdateOperationContainer<T>, B>
        extends AddOperationTypeSupportFacade<T, A, B> {
    private final List<? extends PartnerAddOperationTypeSupport<? extends T, A, B>> supports;

    public PartnerAddOperationTypeSupportFacade(
            List<? extends PartnerAddOperationTypeSupport<? extends T, A, B>> supports) {
        super(supports);
        this.supports = supports;
    }

    public void onDuplicate(A addContainer, List<? extends T> models) {
        getModelsGroupedByPartnerTypeSupports(models)
                .forEach((support, typedModels) -> onDuplicate(support, addContainer, typedModels));

    }

    private <M extends T> void onDuplicate(
            PartnerAddOperationTypeSupport<M, A, B> support,
            A addContainer,
            List<? extends T> typedModels) {

        //noinspection unchecked
        List<M> models = mapList(typedModels, c -> (M) c);
        support.onDuplicate(addContainer, models);
    }

    private Map<? extends PartnerAddOperationTypeSupport<? extends T, A, B>, ? extends List<? extends T>>
    getModelsGroupedByPartnerTypeSupports(
            Collection<? extends T> models) {
        return getObjectsByTypeSupports(supports, models, Object::getClass);
    }

}
