package ru.yandex.partner.core.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.jooq.DSLContext;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.repository.TypeModifyRepository;
import ru.yandex.direct.multitype.repository.container.RepositoryContainer;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.ModelsPreValidatedStep;
import ru.yandex.direct.operation.add.ModelsValidatedStep;
import ru.yandex.direct.operation.add.SimpleAbstractAddOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupportFacade;
import ru.yandex.partner.core.operation.container.ModeContainer;

public class PartnerTypedAddOperation<
        BASE extends ModelWithId,
        M extends BASE,
        AC,
        UC extends UpdateOperationContainer<BASE> & RepositoryContainer & ModeContainer
        >
        extends SimpleAbstractAddOperation<M, Long> {
    private final DSLContext dslContext;
    private final PartnerAddOperationTypeSupportFacade<BASE, UC, AC> addOperationTypeSupportFacade;
    private final ValidationTypeSupportFacade<BASE, UC, UC> validationTypeSupportFacade;
    private final TypeModifyRepository<BASE, BASE, UC, UC> typedModifyRepository;
    private final UC container;

    public PartnerTypedAddOperation(
            Applicability applicability,
            List<M> models,
            DSLContext dslContext,
            PartnerAddOperationTypeSupportFacade<BASE, UC, AC> addOperationTypeSupportFacade,
            ValidationTypeSupportFacade<BASE, UC, UC> validationTypeSupportFacade,
            TypeModifyRepository<BASE, BASE, UC, UC> typedModifyRepository,
            UC container
    ) {
        super(applicability, models);
        this.dslContext = dslContext;
        this.addOperationTypeSupportFacade = addOperationTypeSupportFacade;
        this.validationTypeSupportFacade = validationTypeSupportFacade;
        this.typedModifyRepository = typedModifyRepository;
        this.container = container;
    }

    @Override
    protected ValidationResult<List<M>, Defect> preValidate(List<M> models) {
        if (container.getMode() == OperationMode.DUPLICATE) {
            addOperationTypeSupportFacade.onDuplicate(container, models);
        }

        ValidationResult<List<M>, Defect> vr = new ValidationResult<>(models);
        validationTypeSupportFacade.addPreValidate(container, vr);
        return vr;
    }

    @Override
    protected void onPreValidated(ModelsPreValidatedStep<M> modelsPreValidatedStep) {
        addOperationTypeSupportFacade.onPreValidated(
                container,
                modelsPreValidatedStep.getModels()
        );
    }

    @Override
    protected void beforeExecution(Map<Integer, M> validModelsMapToApply) {
        addOperationTypeSupportFacade.beforeExecution(
                container,
                new ArrayList<>(validModelsMapToApply.values())
        );
    }

    @Override
    protected void validate(ValidationResult<List<M>, Defect> preValidationResult) {
        if (!preValidationResult.hasAnyErrors()) {
            // Если есть какие-то ошибки, продолжать валидировать невозможно
            // так как могут отсутствовать необходимые параметры для валидации
            validationTypeSupportFacade.validate(container, preValidationResult);
        }
    }

    @Override
    protected void onModelsValidated(ModelsValidatedStep<M> modelsValidatedStep) {
        addOperationTypeSupportFacade.onModelsValidated(container, modelsValidatedStep.getModels());
    }

    @Override
    protected List<Long> execute(List<M> validModelsToApply) {
        return typedModifyRepository.add(dslContext, container, validModelsToApply);
    }

    @Override
    protected void onExecuted(Map<Integer, M> validModelsMapToApply) {
        addOperationTypeSupportFacade.afterExecution(
                container,
                new ArrayList<>(validModelsMapToApply.values())
        );
    }
}
