package ru.yandex.partner.core.operation.factory;

import java.util.List;

import org.jooq.DSLContext;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.repository.TypeModifyRepository;
import ru.yandex.direct.multitype.repository.container.RepositoryContainer;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.AbstractAddOperation;
import ru.yandex.partner.core.multitype.service.validation.type.ValidationTypeSupportFacade;
import ru.yandex.partner.core.operation.PartnerAddOperationTypeSupportFacade;
import ru.yandex.partner.core.operation.PartnerTypedAddOperation;
import ru.yandex.partner.core.operation.container.ModeContainer;

public abstract class PartnerAddOperationFactory<
        BASE extends ModelWithId,
        AC,
        UC extends UpdateOperationContainer<BASE> & RepositoryContainer & ModeContainer> {

    private final DSLContext dslContext;
    private final PartnerAddOperationTypeSupportFacade<BASE, UC, AC> addOperationTypeSupportFacade;
    private final ValidationTypeSupportFacade<BASE, UC, UC> validationTypeSupportFacade;
    private final TypeModifyRepository<BASE, BASE, UC, UC> typedModifyRepository;

    protected PartnerAddOperationFactory(
            DSLContext dslContext,
            PartnerAddOperationTypeSupportFacade<BASE, UC, AC> addOperationTypeSupportFacade,
            ValidationTypeSupportFacade<BASE, UC, UC> validationTypeSupportFacade,
            TypeModifyRepository<BASE, BASE, UC, UC> typedModifyRepository) {
        this.dslContext = dslContext;
        this.addOperationTypeSupportFacade = addOperationTypeSupportFacade;
        this.validationTypeSupportFacade = validationTypeSupportFacade;
        this.typedModifyRepository = typedModifyRepository;
    }


    public <M extends BASE> AbstractAddOperation<M, Long> createAddOperation(
            Applicability applicability,
            List<M> models,
            UC container) {
        return new
                PartnerTypedAddOperation<>(
                applicability,
                models,
                dslContext,
                addOperationTypeSupportFacade,
                validationTypeSupportFacade,
                typedModifyRepository,
                container);
    }
}
