package ru.yandex.partner.core.operation.factory;

import java.util.Collection;
import java.util.List;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.update.SimpleAbstractUpdateOperation;

public interface UpdateOperationFactory<T extends ModelWithId, O extends SimpleAbstractUpdateOperation<T, Long>> {
    O createUpdateOperation(
            Applicability applicability,
            List<ModelChanges<T>> modelChanges);

    O createUpdateOperationWithPreloadedModels(
            Applicability applicability,
            List<ModelChanges<T>> modelChanges,
            Collection<T> preloadedModels);
}
