package ru.yandex.partner.core.service.entitymanager;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

public class EntityMeta {
    private final String name;
    private final Class<? extends ModelWithId> entityClass;
    private final ModelQueryService<? extends ModelWithId> modelQueryService;
    private final MultistateGraph<? extends ModelWithId, ?> multistateGraph;

    public EntityMeta(
            String name,
            Class<? extends ModelWithId> entityClass,
            ModelQueryService<? extends ModelWithId> modelQueryService,
            MultistateGraph<? extends ModelWithId, ?> multistateGraph
    ) {
        this.name = name;
        this.entityClass = entityClass;
        this.modelQueryService = modelQueryService;
        this.multistateGraph = multistateGraph;
    }

    public ModelQueryService<? extends ModelWithId> getModelQueryService() {
        return this.modelQueryService;
    }

    public MultistateGraph<? extends ModelWithId, ?> getMultistateGraph() {
        return this.multistateGraph;
    }

    public Class<? extends ModelWithId> getEntityClass() {
        return this.entityClass;
    }
}
