package ru.yandex.partner.core.service.msf;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import org.springframework.stereotype.Service;

import ru.yandex.partner.core.service.msf.dto.DefaultFormatDto;
import ru.yandex.partner.core.service.msf.dto.FormatGroupDto;
import ru.yandex.partner.core.service.msf.dto.FormatWithSettingsDto;
import ru.yandex.partner.core.service.msf.dto.MsfValidationResultDto;

@Service
public interface FormatSystemService {

    default List<FormatGroupDto> getFormats(String form, String lang, String userRole, String site) {
        return List.of();
    }

    @Nullable
    default FormatWithSettingsDto getFormatSettings(String formatName, String lang, String userRole, String site) {
        return new FormatWithSettingsDto();
    }

    MsfValidationResultDto validate(String lang, String userRole, String site, Map<String, Object> data);

    MsfValidationResultDto validatePCodeSettings(String lang, String userRole, String site, Boolean isAdfox,
                                                 Map<String, Object> data);

    @Nullable
    DefaultFormatDto getDefaultFormats(String lang, String userRole, String siteVersion, Boolean isAdfox);
}
