package ru.yandex.partner.core.service.msf;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.service.msf.dto.FormatSettingDto;

@Service
public class MsfAdjustService {

    private static final Map<String, Class<?>> JS_TO_JAVA_TYPE = Map.of(
            "boolean", Boolean.class,
            "integer", Integer.class,
            "number", Number.class,
            "string", String.class,
            "array", List.class,
            "object", Map.class
    );

    private final ObjectMapper objectMapper;

    public MsfAdjustService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Object adjustValue(FormatSettingDto formatSetting, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> targetJavaType = JS_TO_JAVA_TYPE.get(formatSetting.getJsType());
        if (targetJavaType == null) {
            return value;
        }
        if (targetJavaType == Integer.class) {
            Number asNumber;
            if (value instanceof String) {
                asNumber = objectMapper.convertValue(((String) value).trim(), Number.class);
            } else {
                asNumber = objectMapper.convertValue(value, Number.class);
            }
            if (asNumber == null) {
                return null;
            }
            return (int) Math.round(asNumber.doubleValue());
        }
        if (targetJavaType == Number.class && value instanceof Boolean) {
            return objectMapper.convertValue(Boolean.TRUE.equals(value) ? 1 : 0, targetJavaType);
        }
        return objectMapper.convertValue(value, targetJavaType);
    }
}
