package ru.yandex.partner.core.service.msf;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.block.container.BlockContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.service.OperationMode;

public class MsfUtils {
    private MsfUtils() {
    }

    public static String getMsfRole(BlockContainer container, Class<? extends BaseBlock> clazz) {
        return getMsfRole(container.getCanValidateDesignAsManager(clazz), container.getMode());
    }

    public static String getMsfRole(boolean canValidateAsManager, OperationMode mode) {
        return !canValidateAsManager && !mode.equals(OperationMode.DUPLICATE)
                ? CoreConstants.Msf.MSF_PARTNER_ROLE
                : CoreConstants.Msf.MSF_MANAGER_ROLE;
    }
}
