package ru.yandex.partner.core.service.msf.dto;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class FormatGroupDto {
    private String name;
    private String title;
    private List<FormatDto> formats;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<FormatDto> getFormats() {
        return formats;
    }

    public void setFormats(List<FormatDto> formats) {
        this.formats = formats;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FormatGroupDto that = (FormatGroupDto) o;
        return name.equals(that.name) && title.equals(that.title);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, title);
    }

    @Override
    public String toString() {
        return "FormatGroupDto{" +
                "name='" + name + '\'' +
                ", title='" + title + '\'' +
                '}';
    }
}
