package ru.yandex.partner.core.service.msf.dto;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class FormatSettingDto {
    private String name;
    private String title;
    private String description;
    private FormatSettingGroupDto group;
    private FormatSettingType type;
    private String jsType;

    public String getJsType() {
        return jsType;
    }

    public void setJsType(String jsType) {
        this.jsType = jsType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FormatSettingGroupDto getGroup() {
        return group;
    }

    public void setGroup(FormatSettingGroupDto group) {
        this.group = group;
    }

    public FormatSettingType getType() {
        return type;
    }

    public void setType(FormatSettingType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FormatSettingDto that = (FormatSettingDto) o;
        return Objects.equals(name, that.name)
                && Objects.equals(title, that.title)
                && Objects.equals(description, that.description)
                && Objects.equals(group, that.group)
                && Objects.equals(type, that.type)
                && Objects.equals(jsType, that.jsType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, title, description, group, type, jsType);
    }
}
