package ru.yandex.partner.core.service.msf.dto;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class FormatSettingValue {
    private Object value;
    private String title;

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FormatSettingValue that = (FormatSettingValue) o;
        return Objects.equals(value, that.value) && Objects.equals(title, that.title);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value, title);
    }
}
