package ru.yandex.partner.core.service.msf.dto;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class FormatWithSettingsDto {
    private String name;
    private String title;
    private String description;
    private List<FormatSettingDto> settings;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<FormatSettingDto> getSettings() {
        return settings;
    }

    public void setSettings(List<FormatSettingDto> settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FormatWithSettingsDto that = (FormatWithSettingsDto) o;
        return Objects.equals(name, that.name) && Objects.equals(title, that.title) && Objects.equals(description,
                that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, title, description);
    }
}
