package ru.yandex.partner.core.service.msf.dto;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class MsfValidationResultDto {
    private boolean valid;
    private List<MsfMessageDto> messages;
    private Map<String, MsfValidationResultDto> items;

    public boolean isValid() {
        return valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public List<MsfMessageDto> getMessages() {
        return messages;
    }

    public void setMessages(List<MsfMessageDto> messages) {
        this.messages = messages;
    }

    public Map<String, MsfValidationResultDto> getItems() {
        return items;
    }

    public void setItems(Map<String, MsfValidationResultDto> items) {
        this.items = items;
    }

    public MsfValidationResultDto withValid(boolean valid) {
        this.valid = valid;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsfValidationResultDto that = (MsfValidationResultDto) o;
        return valid == that.valid && Objects.equals(messages, that.messages) && Objects.equals(items, that.items);
    }

    @Override
    public int hashCode() {
        return Objects.hash(valid, messages, items);
    }
}
