package ru.yandex.partner.core.service.statevalidation.block;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CronValidationResultDto {
    private final long problemElements;
    private final long totalElements;
    private final String validatedModel;
    private final boolean interrupted;


    public CronValidationResultDto(long problemElements, long totalElements, String validatedModel,
                                   boolean interrupted) {
        this.problemElements = problemElements;
        this.totalElements = totalElements;
        this.validatedModel = validatedModel;
        this.interrupted = interrupted;
    }

    public long getProblemElements() {
        return problemElements;
    }

    public long getTotalElements() {
        return totalElements;
    }

    public String getValidatedModel() {
        return validatedModel;
    }

    @Override
    public String toString() {
        return getValidatedModel() + (interrupted ? " [ОСТАНОВЛЕНО]" : "[ЗАВЕРШЕНО]")
                + " - Всего проблемных элементов - " +
                String.format("%d/%d", getProblemElements(), getTotalElements());
    }

    public boolean wasInterrupted() {
        return interrupted;
    }
}
