package ru.yandex.partner.core.service.statevalidation.block;

import java.util.Set;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.service.BlockValidationService;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.service.PageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbModel;
import ru.yandex.partner.libs.i18n.TranslatableError;

import static ru.yandex.partner.core.CoreConstants.TECHNICAL_RTB_BLOCK_ID;

@Service
public class InternalMobileRtbStateValidationService
        extends BlockStateValidationService<InternalMobileRtbBlock, InternalMobileApp> {
    private final CoreFilterNode<BaseBlock> notTechnicalBlockId;
    private final Set<ModelProperty<? extends Model, ?>> modelProperties;

    public InternalMobileRtbStateValidationService(
            BlockValidationService blockValidationService,
            BlockService blockService, PageService pageService,
            @Value("${cron.validation.internalMobileRtbBlock.threadsCount}") int threadsCount,
            @Value("${cron.validation.internalMobileRtbBlock.step}") int step,
            DefectPresentationRegistry<TranslatableError> defectRegistry,
            ObjectMapper objectMapper) {

        super(blockValidationService, blockService, pageService, threadsCount, step, defectRegistry, objectMapper);
        this.notTechnicalBlockId = CoreFilterNode.create(BlockFilters.BLOCK_ID,
                FilterOperator.NOT_EQUALS, TECHNICAL_RTB_BLOCK_ID);
        this.modelProperties = (Set<ModelProperty<? extends Model, ?>>) InternalMobileRtbBlock.allModelProperties();
    }

    @Override
    protected ContextOnSiteRtbModel getModel() {
        return ContextOnSiteRtbModel.internal_mobile_app_rtb;
    }

    @Override
    protected Class<InternalMobileRtbBlock> getBlockClass() {
        return InternalMobileRtbBlock.class;
    }

    @Override
    protected Class<InternalMobileApp> getPageClass() {
        return InternalMobileApp.class;
    }

    @Override
    protected CoreFilterNode<BaseBlock> prepareAdditionalBlockFilters() {
        return notTechnicalBlockId;
    }

    @Override
    protected Set<ModelProperty<? extends Model, ?>> getModelProperties() {
        return modelProperties;
    }

    @Override
    public String getValidatedModelName() {
        return "internal_mobile_app_rtb";
    }
}
