package ru.yandex.partner.core.service.statevalidation.block;


import java.util.Set;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.service.BlockValidationService;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.service.PageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbModel;
import ru.yandex.partner.libs.i18n.TranslatableError;

import static ru.yandex.partner.core.CoreConstants.TECHNICAL_RTB_BLOCK_ID;

@Service
public class InternalRtbBlockStateValidationService extends BlockStateValidationService<InternalRtbBlock,
        InternalContextPage> {
    private final CoreFilterNode<BaseBlock> notTechnicalBlockId;
    private final Set<ModelProperty<? extends Model, ?>> modelProperties;

    @Autowired
    public InternalRtbBlockStateValidationService(
            BlockValidationService blockValidationService,
            BlockService blockService,
            PageService pageService,
            @Value("${cron.validation.internalRtbBlock.threadsCount}") int threadsCount,
            @Value("${cron.validation.internalRtbBlock.step}") int step,
            DefectPresentationRegistry<TranslatableError> defectRegistry,
            ObjectMapper objectMapper) {

        super(blockValidationService, blockService, pageService, threadsCount, step, defectRegistry, objectMapper);
        this.notTechnicalBlockId = CoreFilterNode.create(BlockFilters.BLOCK_ID,
                FilterOperator.NOT_EQUALS, TECHNICAL_RTB_BLOCK_ID);
        this.modelProperties = (Set<ModelProperty<? extends Model, ?>>) InternalRtbBlock.allModelProperties();
    }

    @Override
    protected Class<InternalRtbBlock> getBlockClass() {
        return InternalRtbBlock.class;
    }

    @Override
    protected Class<InternalContextPage> getPageClass() {
        return InternalContextPage.class;
    }

    @Override
    protected ContextOnSiteRtbModel getModel() {
        return ContextOnSiteRtbModel.internal_context_on_site_rtb;
    }

    @Override
    public String getValidatedModelName() {
        return "internal_context_on_site_rtb";
    }

    @Override
    protected CoreFilterNode<BaseBlock> prepareAdditionalBlockFilters() {
        return notTechnicalBlockId;
    }

    @Override
    protected Set<ModelProperty<? extends Model, ?>> getModelProperties() {
        return this.modelProperties;
    }
}
