package ru.yandex.partner.core.service.statevalidation.block;


import java.util.Set;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.service.BlockValidationService;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.entity.page.service.PageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbModel;
import ru.yandex.partner.libs.i18n.TranslatableError;

import static ru.yandex.partner.core.CoreConstants.TECHNICAL_RTB_BLOCK_ID;

@Service
public class MobileRtbStateValidationService extends BlockStateValidationService<MobileRtbBlock, MobileAppSettings> {
    private final CoreFilterNode<BaseBlock> notTechnicalBlockId;
    private final Set<ModelProperty<? extends Model, ?>> modelProperties;

    @Autowired
    public MobileRtbStateValidationService(BlockValidationService blockValidationService,
                                           BlockService blockService,
                                           PageService pageService,
                                           @Value("${cron.validation.mobileRtbBlock.threadsCount}")int threadsCount,
                                           @Value("${cron.validation.mobileRtbBlock.step}")int step,
                                           DefectPresentationRegistry<TranslatableError> defectRegistry,
                                           ObjectMapper objectMapper) {
        super(blockValidationService, blockService, pageService, threadsCount, step, defectRegistry, objectMapper);
        this.notTechnicalBlockId = CoreFilterNode.create(BlockFilters.BLOCK_ID,
                FilterOperator.NOT_EQUALS, TECHNICAL_RTB_BLOCK_ID);
        this.modelProperties = (Set<ModelProperty<? extends Model, ?>>) MobileRtbBlock.allModelProperties();
    }

    @Override
    protected Class<MobileRtbBlock> getBlockClass() {
        return MobileRtbBlock.class;
    }

    @Override
    protected Class<MobileAppSettings> getPageClass() {
        return MobileAppSettings.class;
    }

    @Override
    protected ContextOnSiteRtbModel getModel() {
        return ContextOnSiteRtbModel.mobile_app_rtb;
    }

    @Override
    public String getValidatedModelName() {
        return "mobile_app_rtb";
    }

    @Override
    protected CoreFilterNode<BaseBlock> prepareAdditionalBlockFilters() {
        return notTechnicalBlockId;
    }

    @Override
    protected Set<ModelProperty<? extends Model, ?>> getModelProperties() {
        return this.modelProperties;
    }
}
