package ru.yandex.partner.core.service.statevalidation.block;


import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class ValidationDefectDto {
    @JsonProperty("public_id")
    private String publicId;
    @JsonProperty("unique_id")
    private Long uniqueId;
    @JsonProperty("errors")
    private List<ValidationErrorDto> errors;

    public ValidationDefectDto(Long uniqueId, String publicId, List<ValidationErrorDto> errors) {
        this.uniqueId = uniqueId;
        this.publicId = publicId;
        this.errors = errors;
    }

    public Long getUniqueId() {
        return uniqueId;
    }

    public String getPublicId() {
        return publicId;
    }

    public List<ValidationErrorDto> getErrors() {
        return errors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidationDefectDto that = (ValidationDefectDto) o;
        return Objects.equals(uniqueId, that.uniqueId) && Objects.equals(publicId, that.publicId)
                && Objects.equals(errors, that.errors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uniqueId, publicId, errors);
    }

    public static class ValidationErrorDto {
        private String path;
        private String msg;

        @JsonSerialize(using = ValidationErrorValueSerializer.class)
        private Object value;

        public ValidationErrorDto(String path, String msg, Object value) {
            this.path = path;
            this.msg = msg;
            this.value = value;
        }

        public String getPath() {
            return path;
        }

        public String getMsg() {
            return msg;
        }

        public Object getValue() {
            return value;
        }

    }

}
