package ru.yandex.partner.core.service.statevalidation.block;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;

public class ValidationErrorValueSerializer extends JsonSerializer<Object> {

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value instanceof Message m) {
            gen.writeRawValue(JsonFormat.printer().print(m));
        } else {
            gen.writeObject(value);
        }
    }
}
