package ru.yandex.partner.core.typesupport.update;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.multitype.service.type.update.AbstractUpdateOperationTypeSupport;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportFacade;

@ParametersAreNonnullByDefault
public abstract class PartnerBaseUpdateOperationTypeSupport<
        T extends ModelWithId,
        A extends UpdateOperationContainer<?>,
        B, C
        > extends AbstractUpdateOperationTypeSupport<T, A, B, C> {

    private final PartnerRepositoryTypeSupportFacade<? super T, ?, ?, ?> repositoryFacade;
    private Set<ModelProperty<? extends Model, ?>> affectedProps;

    public PartnerBaseUpdateOperationTypeSupport(
            PartnerRepositoryTypeSupportFacade<? super T, ?, ?, ?> repositoryFacade) {
        this.repositoryFacade = repositoryFacade;
    }

    @PostConstruct
    private void init() {
        // из-за того что в DefaultsInitializingUpdateSupport coreModel сетится после вызова super()
        // иначе будет npe в getTypeClass()
        this.affectedProps = repositoryFacade.getModelPropertiesByModel(getTypeClass());
    }

    public Set<ModelProperty<? extends Model, ?>> getAffectedProps() {
        return affectedProps;
    }
}
