package ru.yandex.partner.core.typesupport.update;

import java.util.function.Function;

import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

/**
 * @param <M>  Модель TypeSupport-а
 * @param <MT> Тип параметра модели
 * @param <R>  jooq record таблицы
 * @param <RT> тип параметра jooq record field-а
 */
public class UpdateObjectTypeSupport<M extends Model, MT, R extends Record, RT> {
    private final ModelProperty<? super M, MT> modelProperty;
    private final TableField<R, RT> tableField;
    private final Function<MT, RT> converter;
    private final Function<M, String> validator;

    public UpdateObjectTypeSupport(ModelProperty<? super M, MT> modelProperty, TableField<R, RT> tableField,
                                   Function<MT, RT> converter,
                                   Function<ModelProperty<? super M, MT>, Function<M, String>> validator) {
        this.modelProperty = modelProperty;
        this.tableField = tableField;
        this.converter = converter;
        this.validator = validator.apply(modelProperty);
    }

    public ModelProperty<? super M, MT> getModelProperty() {
        return modelProperty;
    }

    public TableField<R, RT> getTableField() {
        return tableField;
    }

    public Function<MT, RT> getConverter() {
        return converter;
    }

    public Function<M, String> getValidator() {
        return validator;
    }

    public static <M extends Model, R extends Record> UpdateObjectTypeSupport<M, String, R, String> stringType(
            ModelProperty<? super M, String> modelProperty,
            TableField<R, String> tableField,
            Function<ModelProperty<? super M, String>, Function<M, String>> validator
    ) {
        return new UpdateObjectTypeSupport<>(modelProperty, tableField, Function.identity(), validator);
    }

    public static <M extends Model, R extends Record> UpdateObjectTypeSupport<M, Boolean, R, Long> booleanType(
            ModelProperty<? super M, Boolean> modelProperty,
            TableField<R, Long> tableField,
            Function<ModelProperty<? super M, Boolean>, Function<M, String>> validator
    ) {
        return new UpdateObjectTypeSupport<>(modelProperty,
                tableField,
                aBoolean -> aBoolean ? 1L : 0L,
                validator);
    }
}
