package ru.yandex.partner.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;

public class CollectionUtils {

    private CollectionUtils() {
        // Utils
    }

    public static <T, C extends Collection<T>> C checkNotNullAndNotEmpty(C collection) {
        if (Objects.requireNonNull(collection).isEmpty()) {
            throw new IllegalArgumentException("Collection must not be empty");
        }

        return collection;
    }

    public static <T> T[] checkNotNullAndNotEmpty(T[] array) {
        Objects.requireNonNull(array);

        if (array.length == 0) {
            throw new IllegalArgumentException("Array must not be empty");
        }

        return array;
    }

    public static <T> Set<T> removeSetFromSet(Set<T> source, Set<T> removedItems) {
        Set<T> tmpSet = new HashSet<>(source);
        tmpSet.removeAll(removedItems);
        return Collections.unmodifiableSet(tmpSet);
    }


    public static void requireSizeEquals(Collection<?> first, Collection<?> second) {
        if (first.size() != second.size()) {
            throw new IllegalArgumentException("Collections size must be equal. " +
                    first.size() + " != " + second.size());
        }
    }

    /**
     * Собирает стрим объектов в мапку key -> List<T>
     */
    @SuppressWarnings("unchecked")
    public static <T> Collector<T, ?, Map<String, Object>> keyToList(String key) {
        return Collector.of(
                () -> Map.of(key, new ArrayList<>()),
                (m, t) -> ((List<T>) m.get(key)).add(t),
                (m1, m2) -> {
                    var l = (List<T>) m1.get(key);
                    l.addAll((List<T>) m2.get(key));
                    return Map.of(key, l);
                }
        );
    }
}
