package ru.yandex.partner.core.utils;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class ModelPropertyUtils {
    private static final String ALL_MODEL_PROPERTIES_METHOD = "allModelProperties";

    private ModelPropertyUtils() {
        // Utils
    }


    public static <M extends Model> Set<ModelProperty<?, ?>> allModelProperties(Class<M> modelClass) {
        try {
            //noinspection unchecked
            return ((Set<ModelProperty<?, ?>>) modelClass.getMethod(ALL_MODEL_PROPERTIES_METHOD).invoke(null));
        } catch (ReflectiveOperationException | RuntimeException e) {
            throw new RuntimeException(
                    "Could not invoke " + ALL_MODEL_PROPERTIES_METHOD + " for Model " + modelClass, e);
        }
    }

    public static <M extends Model> Set<ModelProperty<?, ?>> allModelProperties(
            Class<M> modelClass,
            Set<ModelProperty<?, ?>> excludeProperties) {

        //noinspection unchecked
        return allModelProperties(modelClass)
                .stream()
                .filter(modelProperty -> !excludeProperties.contains(modelProperty))
                .map(modelProperty -> (ModelProperty<M, ?>) modelProperty)
                .collect(Collectors.toSet());
    }

    public static <M extends Model>
    Set<ModelProperty<? super M, ?>> castSuper(Collection<ModelProperty<?, ?>> modelProperties) {
        //noinspection unchecked
        return modelProperties
                .stream()
                .map(modelProperty -> (ModelProperty<M, ?>) modelProperty)
                .collect(Collectors.toSet());
    }

    public static Set<ModelProperty<? extends Model, ?>> castExtends(Collection<ModelProperty<?, ?>> modelProperties) {
        return modelProperties
                .stream()
                .map(modelProperty -> (ModelProperty<? extends Model, ?>) modelProperty)
                .collect(Collectors.toSet());
    }
}
