package ru.yandex.partner.core.utils;

import org.jooq.SortOrder;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class OrderBy {

    private final ModelProperty<? extends Model, ?> modelProperty;
    private final Direction direction;

    public OrderBy(ModelProperty<? extends Model, ?> modelProperty, Direction direction) {
        this.modelProperty = modelProperty;
        this.direction = direction;
    }

    public OrderBy(ModelProperty<? extends Model, ?> modelProperty) {
        this(modelProperty, Direction.ASC);
    }

    public ModelProperty<? extends Model, ?> getModelProperty() {
        return modelProperty;
    }

    public Direction getDirection() {
        return direction;
    }

    public enum Direction {
        ASC(SortOrder.ASC),
        DESC(SortOrder.DESC);

        private final SortOrder sortOrder;

        Direction(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        public SortOrder getSortOrder() {
            return sortOrder;
        }
    }

}
