package ru.yandex.partner.core.utils;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.multitype.repository.PartnerRepositoryTypeSupportWithMapper;

public class TypeSupportUtils {

    private TypeSupportUtils() {
        // utils
    }

    public static <M extends ModelWithId> JooqMapper<M> buildJooqMapper(
            List<? extends PartnerRepositoryTypeSupportWithMapper<? super M, ?, ?>> repositoryTypeSupportWithMappers,
            Set<Class<?>> filteredClasses) {
        // ВНИМАНИЕ! Лучше помнить
        // Что этот маппер дублирует приходящие, соответственно преобразование из вида Jooq в Модель Дублируется
        // те Два раза может быть вызван set у полей два раза десериализация из json

        List<? extends JooqMapper<? super M>> sourceMappers = repositoryTypeSupportWithMappers.stream()
                .filter(repository -> !filteredClasses.contains(repository.getTypeClass()))
                // Сортировка какая-нибудь, чтобы порядок тегов в json был стабильным в opts
                .sorted(Comparator.comparing(o -> o.getTypeClass().getName()))
                .peek(repository -> {
                    // Тут осознано передаем null так как эти методы не должны делать ничего
                    // Эти функции забирает на себя этот объединяющий класс

                    try {
                        //noinspection ConstantConditions
                        repository.processUpdate(null, null);
                        //noinspection ConstantConditions
                        repository.pushToInsert(null, null);
                    } catch (NullPointerException e) {
                        throw new RuntimeException("""
                                Methods processUpdate and pushToInsert of %s must be empty.
                                Implementation is in the aggregating class"""
                                .formatted(repository.getClass())
                        );
                    }
                })
                .map(PartnerRepositoryTypeSupportWithMapper::getJooqMapper)
                .collect(Collectors.toList());
        return JooqMapperBuilder.builder(sourceMappers).build();
    }
}
