package ru.yandex.partner.core.utils.converter;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.result.ResultConverters;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.action.SimpleActionErrorHandler;
import ru.yandex.partner.core.action.result.ActionsResult;

@ParametersAreNonnullByDefault
public class MassResultConverter {

    private MassResultConverter() {
        //utils
    }

    public static <M> MassResult<M> convertMassResult(MassResult<Long> result) {
        return ResultConverters.<Long, M>massResultConverter(
                        oneResult -> {
                            var validationResult = oneResult.getValidationResult();
                            return new Result<>(
                                    validationResult != null ? (M) validationResult.getValue() : null,
                                    validationResult,
                                    oneResult.getState()
                            );
                        }
                )
                .convert(result);
    }

    public static <M extends ModelWithId> ActionsResult<?> convertToActionResult(Class<M> entityClass,
                                                                                 MassResult<Long> massResult) {
        var actionResult = new ActionsResult<>();
        var typedMassResult = MassResultConverter.<M>convertMassResult(massResult);
        actionResult.putToResults(
                entityClass,
                typedMassResult
        );

        if (!typedMassResult.isSuccessful() || typedMassResult.getErrorCount() > 0) {
            var tmpEh = new SimpleActionErrorHandler<M>();
            tmpEh.addValidationErrors((ValidationResult<List<M>, Defect>) typedMassResult.getValidationResult());
            actionResult.addAllErrors(Map.of(entityClass, tmpEh.getDefects()));
        }

        return actionResult;
    }
}
