package ru.yandex.partner.core.utils.converter;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.model.ModelProperty;

@ParametersAreNonnullByDefault
public class ModelPropertyNameConverter {

    private ModelPropertyNameConverter() {
        //Utils
    }


    public static <T> Map<ModelProperty<? super T, ?>, String> convert(Set<ModelProperty<? super T, ?>> properties,
                                                                       Class<T> clazz) {
        var all = getAllClassFields(clazz);
        return StreamEx.of(properties).collect(Collectors.toMap(prop -> prop, prop -> all.get(prop.name())));

    }

    private static <T> Map<String, String> getAllClassFields(Class<T> clazz) {
        return Arrays.stream(clazz.getDeclaredFields())
                .map(
                        field -> field.isAnnotationPresent(JsonProperty.class)
                                ? Pair.of(field.getName(), field.getAnnotation(JsonProperty.class).value())
                                : Pair.of(field.getName(), field.getName())
                )
                .collect(Collectors.toUnmodifiableMap(Pair::getLeft, Pair::getRight));
    }


}
