package ru.yandex.partner.core.validation.constraints;

import java.util.Set;
import java.util.regex.Pattern;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.partner.core.CoreConstants;

public class PartnerCommonConstraints {

    public static final Pattern EMAIL_PATTERN = Pattern.compile("^" + CoreConstants.RFC822PAT + "$");

    private PartnerCommonConstraints() {
    }

    public static boolean isValidEmailRfc822Pat(String email) {
        return EMAIL_PATTERN.matcher(email).matches();
    }

    public static <T extends ModelWithId> Constraint<ModelChanges<T>, Defect> modelTypeSupportsSuitableInterface(
            Set<Long> supportSuitableInterfaceIds, Defect defect) {
        return Constraint.fromPredicate(modelChanges ->
                supportSuitableInterfaceIds.contains(modelChanges.getId()), defect);
    }
}
