package ru.yandex.partner.core.validation.constraints;

import java.math.BigDecimal;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.defect.NumberDefects;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.partner.core.validation.defects.TypeDefects.invalidTypeMustBeIntegerNumber;

public class PartnerNumberConstraints {
    private PartnerNumberConstraints() {
    }

    public static Constraint<Long, Defect> isZeroOrGreaterIntegerNumber() {
        return fromPredicate(v -> v >= 0, invalidTypeMustBeIntegerNumber());
    }

    public static Constraint<Long, Defect> isIntegerNumberGreaterThanOrEqual(long num) {
        return fromPredicate(v -> v >= num, invalidTypeMustBeIntegerNumber());
    }

    public static Constraint<Long, Defect> isIntegerNumberLessThanOrEqual(long num) {
        return fromPredicate(v -> v <= num, invalidTypeMustBeIntegerNumber());
    }

    public static Constraint<BigDecimal, Defect> maxScale(int maxScale) {
        return fromPredicate(
                bigDecimal -> !(bigDecimal.scale() > maxScale), NumberDefects.inInterval(0, maxScale)
        );
    }
}
