package ru.yandex.partner.core.validation.defects;

import java.util.Collections;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.partner.core.action.exception.DefectInfoWithMsgId;
import ru.yandex.partner.core.action.exception.DefectInfoWithMsgParams;
import ru.yandex.partner.libs.i18n.GettextMsg;

public class DefectInfoBuilder {

    private final GettextMsg gettextMsg;
    private Path path = new Path(Collections.emptyList());
    private Object value = "";

    private DefectInfoBuilder(GettextMsg gettextMsg) {
        this.gettextMsg = gettextMsg;
    }

    public static DefectInfoBuilder of(GettextMsg gettextMsg) {
        return new DefectInfoBuilder(gettextMsg);
    }

    public static <T> DefectInfo<T> createDefectInfo(GettextMsg gettextMsg) {
        return DefectInfoBuilder.of(gettextMsg).build();
    }

    public DefectInfoBuilder withPath(Path path) {
        this.path = path;
        return this;
    }

    public DefectInfoBuilder withValue(Object value) {
        this.value = value;
        return this;
    }

    public <T> DefectInfo<T> build() {
        return new DefectInfo<>(path, value, (T) new Defect(DefectInfoWithMsgId.ID,
                new DefectInfoWithMsgParams(gettextMsg)));
    }
}
