package ru.yandex.partner.core.validation.defects;

import java.util.Set;
import java.util.TreeSet;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.partner.core.validation.defects.params.CollectionDefectParams;

import static ru.yandex.partner.core.validation.defects.ids.PartnerCollectionDefectIds.Entries.DUPLICATE_ENTRIES;
import static ru.yandex.partner.core.validation.defects.ids.PartnerCollectionDefectIds.Entries.ENTRIES_NOT_FOUND;
import static ru.yandex.partner.core.validation.defects.ids.PartnerCollectionDefectIds.Size.MUST_BE_IN_COLLECTION_WITH_PRESENTATION;

public class PartnerCollectionDefects {

    private PartnerCollectionDefects() {
    }

    public static Defect<CollectionDefectParams> inSet(Set<?> c) {
        var copy = new TreeSet<>(c);
        String s = copy.toString();
        return new Defect<>(MUST_BE_IN_COLLECTION_WITH_PRESENTATION,
                new CollectionDefectParams().withStringPresentation(s.substring(1, s.length() - 1)));
    }

    public static Defect<Set<Long>> duplicateEntries(Set<Long> ids) {
        return new Defect<>(DUPLICATE_ENTRIES, ids);
    }

    public static Defect<Set<Long>> entriesNotFound(Set<Long> ids) {
        return new Defect<>(ENTRIES_NOT_FOUND, ids);
    }
}
