package ru.yandex.partner.core.validation.defects;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.partner.core.validation.defects.ids.TypeDefectIds;
import ru.yandex.partner.core.validation.defects.params.InvalidTypeDefectParams;

public class TypeDefects {

    private TypeDefects() {
    }

    public static Defect<InvalidTypeDefectParams> invalidTypeMustBeBoolean() {
        return new Defect<>(TypeDefectIds.DATA_MUST_BE_BOOLEAN);
    }

    public static Defect<InvalidTypeDefectParams> invalidTypeMustBeIntegerNumber() {
        return new Defect<>(TypeDefectIds.DATA_MUST_BE_INTEGER_NUMBER);
    }

    public static Defect<InvalidTypeDefectParams> invalidTypeMustBeDefined() {
        return new Defect<>(TypeDefectIds.DATA_MUST_BE_DEFINED);
    }

    public static Defect<InvalidTypeDefectParams> invalidTypeMustBeNumeric() {
        return new Defect<>(TypeDefectIds.DATA_MUST_BE_NUMERIC);
    }

    public static Defect<InvalidTypeDefectParams> invalidTypeMustBeHexadecimal() {
        return new Defect<>(TypeDefectIds.DATA_MUST_BE_HEXADECIMAL);
    }
}
