package ru.yandex.partner.core.validation.defects.params;

import java.util.StringJoiner;

public class CollectionDefectParams {
    private String stringPresentation;

    public String getStringPresentation() {
        return stringPresentation;
    }

    public CollectionDefectParams withStringPresentation(String stringPresentation) {
        this.stringPresentation = stringPresentation;
        return this;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", CollectionDefectParams.class.getSimpleName() + "[", "]")
                .add("stringPresentation='" + stringPresentation + "'")
                .toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        CollectionDefectParams that = (CollectionDefectParams) o;

        return stringPresentation != null ? stringPresentation.equals(that.stringPresentation) :
                that.stringPresentation == null;
    }

    @Override
    public int hashCode() {
        return stringPresentation != null ? stringPresentation.hashCode() : 0;
    }
}
