package ru.yandex.partner.core.validation.defects.params;

import java.util.Objects;

import ru.yandex.partner.libs.i18n.GettextMsg;

public class InvalidTypeDefectParams {
    private final GettextMsg gettextMsg;

    public InvalidTypeDefectParams(GettextMsg gettextMsg) {
        this.gettextMsg = gettextMsg;
    }

    public GettextMsg getGettextMsg() {
        return gettextMsg;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvalidTypeDefectParams)) {
            return false;
        }
        InvalidTypeDefectParams that = (InvalidTypeDefectParams) o;
        return Objects.equals(gettextMsg, that.gettextMsg);
    }

    @Override
    public int hashCode() {
        return Objects.hash(gettextMsg);
    }

    @Override
    public String toString() {
        return "InvalidTypeDefectParams{" +
                "gettextMsg=" + gettextMsg +
                '}';
    }
}
