package ru.yandex.partner.core.validation.defects.presentation;

import javax.annotation.Nonnull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;

public enum CommonValidationMsg implements GettextMsg {
    LENGTH_MORE_THAN(msg("Length \"%s\" more than \"%s\""), "lib__QBit__Validator.pm"),
    LENGTH_CANNOT_BE_LESS_THAN_MIN(msg("Length \"%s\" less than \"%s\""), "lib__QBit__Validator__Type__scalar.pm"),
    UNKNOWN_FIELDS(msg("Unknown fields: %s"), "lib__Application__Model__Product__AN__ContextOnSite__Direct.pm"),
    DATA_MUST_BE_HASH(msg("Data must be HASH"), "lib__QBit__Validator.pm"),
    DATA_MUST_BE_ARRAY(msg("Data must be ARRAY"), "lib__QBit__Validator.pm"),
    DATA_MUST_BE_BOOLEAN(msg("Expected type boolean"), "lib__QBit__Validator__Type__boolean.pm"),
    DATA_MUST_BE_NUMBER(msg("Data must be numeric, but got \"%s\""), "lib__QBit__Validator__Type__scalar.pm"),
    DATA_MUST_BE_STRING(msg("Data must be STRING"), "lib__QBit__Validator.pm"),
    DATA_MUST_BE_NULL(msg("Data must be null"), "lib__QBit__Validator__Type__scalar.pm"),
    DATA_CANNOT_BE_NULL(msg("Key \"%s\" required"), "lib__QBit__Validator.pm"),
    DATA_MUST_BE_INTEGER_NUMBER(msg("Must be integer number"), "lib__QBit__Validator__Type__int_un.pm"),
    DATA_MUST_BE_DEFINED(msg("Data must be defined"), "lib__QBit__Validator.pm"),
    DATA_MUST_BE_IN_COLLECTION(msg("Got value \"%s\" not in array: %s"), "lib__QBit__Validator.pm"),
    DUPLICATE_ENTRIES(msg("Identical records found for id: %s"), "lib__QBit__Validator__Type__articles.pm"),
    INCORRECT_JSON(msg("Incorrect json"), "lib__QBit__Validator__Type__json.pm"),
    ENTRIES_NOT_FOUND(msg("Entry with id: '%s' not found"), "lib__QBit__Validator__Type__Dict.pm"),
    UNKNOWN_KEY(msg("Extra fields: %s"), "lib__QBit__Validator.pm"),
    FIELD_SHOULD_BE_POSITIVE_NUMBER(msg("Field \"%s\" should be a positive number"),
            "lib__Application__Model__Users.pm"),
    CANNOT_ADD_FIELDS(msg("You can't use following fields in add: %s"), "lib__Application__Model__Product.pm"),
    MUST_BE_UINT(msg("Must be an unsigned integer"), "lib__QBit__Validator__Type__int_un.pm"),
    INVALID_VALUE(msg("Invalid value"), "lib__QBit__Validator.pm");

    private final GettextMsgPayload payload;
    private final String keysetName;

    CommonValidationMsg(GettextMsgPayload.Builder builder, String keysetName) {
        this.payload = builder.build();
        this.keysetName = keysetName;
    }

    @Nonnull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @Nonnull
    @Override
    public String getKeysetName() {
        return keysetName;
    }
}
