package ru.yandex.partner.core.validation.defects.presentation;

import java.util.function.Function;

import javax.annotation.Nullable;

import ru.yandex.direct.validation.presentation.DefectPresentationProvider;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.partner.core.entity.block.service.validation.defects.SimpleParamGetter;
import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.MsgWithArgs;
import ru.yandex.partner.libs.i18n.TranslatableError;

public class DefectPresentationProviders {
    private DefectPresentationProviders() {
    }

    public static <T> DefectPresentationProvider<T, TranslatableError> getProvider(
            Function<DefectInfo<? extends Defect<T>>, GettextMsg> defectIdToGettextMsg) {
        return defectInfo -> new TranslatableError(
                getErrorPath(defectInfo),
                defectIdToGettextMsg.apply(defectInfo)
        );
    }

    public static <T> DefectPresentationProvider<T, TranslatableError> defaultDefectProvider(GettextMsg msg) {
        return defectInfo -> new TranslatableError(getErrorPath(defectInfo), msg);
    }

    public static <T extends SimpleParamGetter> DefectPresentationProvider<T, TranslatableError>
    getParamProvider(GettextMsg msg) {
        return getProvider(defectInfo ->
                MsgWithArgs.of(msg,
                        defectInfo.getDefect().params().getParam()));
    }

    public static <T> DefectPresentationProvider<T, TranslatableError>
    passThroughParamProvider(GettextMsg msg) {
        return getProvider(defectInfo ->
                MsgWithArgs.of(msg, defectInfo.getDefect().params()));
    }

    @Nullable
    public static String getErrorPath(DefectInfo<? extends Defect> defectInfo) {
        if (defectInfo.getPath().isEmpty()) {
            return null;
        } else {
            StringBuilder sb = new StringBuilder("/data");
            sb.append("/attributes");
            defectInfo.getPath().getNodes().forEach(node -> sb.append("/".concat(node.toString())));
            return sb.toString();
        }
    }
}
