package ru.yandex.partner.defaultconfiguration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.clickhouse.ClickHouseDataSource;

@Configuration
public class ClickHouseConfiguration {
    public static final String CLICKHOUSE_DATASOURCE_BEAN_NAME = "clickhouseDataSource";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClickHouseConfiguration.class);

    @Bean(name = CLICKHOUSE_DATASOURCE_BEAN_NAME)
    ClickHouseDataSource clickhouseDataSource(
            @Value("${clickhouse.url:}") String jdbcUrl,
            @Value("${clickhouse.username:}") String username,
            @Value("${clickhouse.password:}") String password
    ) {
        LOGGER.info("Bean {}", ClickHouseConfiguration.class);
        ClickHouseDataSource clickHouseDataSource = new ClickHouseDataSource(jdbcUrl);
        clickHouseDataSource.getProperties().setUser(username);
        clickHouseDataSource.getProperties().setPassword(password);
        return clickHouseDataSource;
    }
}
