package ru.yandex.partner.defaultconfiguration;

import java.time.Duration;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "mysql")
public class MysqlProps {
    private String host;
    private String port;
    private String schema;
    private String params;
    private String username;
    private String password;
    private Duration connectionTimeout;
    private Duration lockWaitTimeout;
    private Integer maxPoolSize;

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getSchema() {
        return schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Duration getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Duration getLockWaitTimeout() {
        return lockWaitTimeout;
    }

    public void setLockWaitTimeout(Duration lockWaitTimeout) {
        this.lockWaitTimeout = lockWaitTimeout;
    }

    public Integer getMaxPoolSize() {
        return maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    @Override
    public String toString() {
        return "MysqlProps{" +
                "host='" + host + '\'' +
                ", port='" + port + '\'' +
                ", schema='" + schema + '\'' +
                ", params='" + params + '\'' +
                ", username='" + username + '\'' +
                ", password='***'" +
                ", connectionTimeout=" + connectionTimeout +
                ", lockWaitTimeout=" + lockWaitTimeout +
                ", maxPoolSize=" + maxPoolSize +
                '}';
    }
}
