package ru.yandex.partner.defaultconfiguration;

import java.lang.management.ManagementFactory;
import java.time.Clock;
import java.util.TimeZone;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Настраивает timezone для приложения с помощью Spring properties
 * Приоритет:
 * - JAVA_OPTS (-Duser.timezone=...)
 * - Spring Properties (jvm.user.timezone:...)
 */
@Configuration
public class TimeZoneConfiguration {

    public TimeZoneConfiguration(@Value("${jvm.user.timezone:Europe/Moscow}") TimeZone timeZone) {
        boolean hasJvmArgument = false;
        var runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeMXBean != null) {
            var inputArguments = runtimeMXBean.getInputArguments();
            if (inputArguments != null) {
                for (String inputArgument : inputArguments) {
                    if (inputArgument.startsWith("-Duser.timezone=")) {
                        hasJvmArgument = true;
                        break;
                    }
                }
            }
        }

        if (!hasJvmArgument) {
            TimeZone.setDefault(timeZone);
        }
    }

    @Bean
    public Clock defaultClock() {
        return Clock.systemDefaultZone();
    }

    @Bean
    public PartnerLocalDateTime partnerLocalDateTime(Clock clock) {
        return new PartnerLocalDateTime(clock);
    }
}
