package ru.yandex.partner.defaultconfiguration.healthchecks;

import org.jooq.DSLContext;
import org.jooq.Record1;
import org.jooq.Result;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class DBCheck implements HealthIndicator {
    private final DSLContext dslContext;

    public DBCheck(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public Health health() {

        Health.Builder status;

        try {
            Result<Record1<Integer>> result = dslContext.selectOne().fetch();

            if (result.get(0).value1() == 1) {
                status = Health.up();
            } else {
                status = Health.down().withDetail("db", String.format("Expected 1 but got %s", result.get(0).value1()));
            }
        } catch (Exception e) {
            status = Health.down().withException(e);
        }

        return status.build();
    }
}
