package ru.yandex.partner.defaultconfiguration.logging;


import ru.yandex.logbroker.agent.logback.appender.MetaItem;
import ru.yandex.logbroker.agent.logback.appender.UnifiedLoggerAppender;

public class UnifiedLoggerWithCustomConverterAppender extends UnifiedLoggerAppender {

    private String profile;
    private String source;

    public UnifiedLoggerWithCustomConverterAppender() {
        super.setMessageConverter(ErrorBoosterMessageConverter.class.getName());

        var metaItem = new MetaItem();
        metaItem.setKey("topic");
        metaItem.setValue("partner.error-booster");
        addMessageMeta(metaItem);
    }

    public String getProfile() {
        return profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
        ErrorBoosterMessageConverter.setErrorBoosterEnvBySpringProfile(profile);
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
        ErrorBoosterMessageConverter.setErrorApplicationSource(source);
    }
}
