package ru.yandex.partner.defaultconfiguration.rpc;

import java.time.Duration;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Базовый класс конфига для клиента внешней ручки
 */
public abstract class BaseRpcConfig implements RpcConfigProps {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRpcConfig.class);

    private final RpcConfigProps defaultProps;
    protected Duration timeout;
    protected Duration delay;
    protected Integer retries;
    protected String url;

    public BaseRpcConfig(RpcConfigProps defaultProps) {
        this.defaultProps = defaultProps;
    }

    @PostConstruct
    private void init() {
        LOGGER.info("Created {}", this);
    }

    @Override
    public Duration getTimeout() {
        return timeout != null ? timeout : defaultProps.getTimeout();
    }

    @Override
    public Duration getDelay() {
        return delay != null ? delay : defaultProps.getDelay();
    }

    @Override
    public Integer getRetries() {
        return retries != null ? retries : defaultProps.getRetries();
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public void setDelay(Duration delay) {
        this.delay = delay;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" +
                "timeout=" + getTimeout() +
                ", delay=" + getDelay() +
                ", retries=" + getRetries() +
                ", url='" + getUrl() + '\'' +
                '}';
    }
}
