package ru.yandex.partner.defaultconfiguration.rpc;

import java.time.Duration;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("default-rpc")
public class DefaultRpcConfig implements RpcConfigProps {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRpcConfig.class);
    private Duration timeout;
    private Duration delay;
    private Integer retries;

    @PostConstruct
    private void init() {
        LOGGER.info("Default configuration for external services calls : {}", this);
    }

    @Override
    public Duration getTimeout() {
        return timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    @Override
    public Duration getDelay() {
        return delay;
    }

    public void setDelay(Duration delay) {
        this.delay = delay;
    }

    @Override
    public Integer getRetries() {
        return retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    @Override
    public String toString() {
        return "DefaultRpcConfig{" +
                "timeout=" + timeout +
                ", delay=" + delay +
                ", retries=" + retries +
                '}';
    }
}
