package ru.yandex.partner.defaultconfiguration.rpc;

import java.time.Duration;

/**
 * Конфигурация для клиентов, которые ходят в сторонние сервисы
 * (e.g msf, баланс)
 */
public interface RpcConfigProps {
    /**
     * Время, за которое мы обязаны получить ответ
     */
    Duration getTimeout();

    /**
     * Задержка между retries запроса, если таковые имеют место (retries > 0)
     */
    Duration getDelay();

    /**
     * Количество перезапросов
     */
    Integer getRetries();
}
