package ru.yandex.partner.libs.actuator.solomon;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.util.MimeTypeUtils;

import ru.yandex.monlib.metrics.encode.json.MetricJsonEncoder;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@WebEndpoint(id = "monlib")
public class MonlibSolomonEndpoint {
    private final MetricRegistry metricRegistry;

    public MonlibSolomonEndpoint(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @ReadOperation(produces = MimeTypeUtils.APPLICATION_JSON_VALUE)
    public String json() throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream()) {
            try (MetricJsonEncoder encoder = new MetricJsonEncoder(outputStream)) {
                metricRegistry.supply(0L, encoder);
            }
            return outputStream.toString(StandardCharsets.UTF_8);
        }
    }
}
