package ru.yandex.partner.libs.actuator.solomon;

import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.kinopoisk.springframework.boot.actuate.autoconfigure.metrics.export.solomon.SolomonMetricsExportAutoConfiguration;
import ru.yandex.kinopoisk.springframework.boot.actuate.autoconfigure.metrics.export.solomon.SolomonProperties;
import ru.yandex.monlib.metrics.JvmGc;
import ru.yandex.monlib.metrics.JvmMemory;
import ru.yandex.monlib.metrics.JvmRuntime;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@Configuration
@AutoConfigureAfter(SolomonMetricsExportAutoConfiguration.class)
@ConditionalOnClass(MetricRegistry.class)
@ConditionalOnProperty(prefix = SolomonProperties.PROPERTIES_PREFIX, name = "enabled", havingValue = "true",
        matchIfMissing = true)
@EnableConfigurationProperties(SolomonProperties.class)
public class MonlibSolomonEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MetricRegistry solomonMetricRegistry() {
        MetricRegistry registry = new MetricRegistry();
        JvmGc.addMetrics(registry);
        JvmMemory.addMetrics(registry);
        JvmRuntime.addMetrics(registry);
        JvmMemory.addMetrics(registry);
        return registry;
    }

    @Configuration
    @ConditionalOnAvailableEndpoint(endpoint = MonlibSolomonEndpoint.class)
    public static class MonlibSolomonEndpointConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public MonlibSolomonEndpoint monlibSolomonEndpoint(MetricRegistry metricRegistry) {
            return new MonlibSolomonEndpoint(metricRegistry);
        }
    }
}
