package ru.yandex.partner.libs.auth.converter;

import javax.servlet.http.HttpServletRequest;

import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationConverter;

import ru.yandex.partner.libs.auth.model.UserAuthenticationHolder;

/**
 * Конвертер, формирующий запрос к менеджеру аутентификации из http-запроса
 */
public class UserAuthenticationConverter implements AuthenticationConverter {

    @Override
    public Authentication convert(HttpServletRequest request) {
        return new UserAuthenticationHolder(request);
    }

}
