package ru.yandex.partner.libs.auth.exception;


import org.springframework.security.core.AuthenticationException;

import ru.yandex.partner.libs.auth.manager.PartnerAuthenticationManager;

/**
 * Исключение-обёртка для AuthenticationException
 * Используется {@link PartnerAuthenticationManager}
 * чтобы обойти стандартное поведение менеджера и выйти с ошибкой,
 * если хотя бы один провайдер не смог авторизовать (хотя пытался)
 */
public class ForceFailureAuthenticationException extends RuntimeException {

    public ForceFailureAuthenticationException(AuthenticationException cause) {
        super(cause);
    }

    public AuthenticationException getAuthenticationException() {
        return (AuthenticationException) this.getCause();
    }

}
